/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeItem;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.item.ArmorMaterialLiving;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.ExpandedArmor;
import wayoftime.bloodmagic.core.LivingArmorRegistrar;
import wayoftime.bloodmagic.core.living.ILivingContainer;
import wayoftime.bloodmagic.core.living.LivingStats;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.core.living.LivingUtil;

public class ItemLivingArmor
extends ArmorItem
implements ILivingContainer,
ExpandedArmor,
IForgeItem {
    private static final int MAX_ABSORPTION = 100000;

    public ItemLivingArmor(EquipmentSlotType slot) {
        super(ArmorMaterialLiving.INSTANCE, slot, new Item.Properties().func_200917_a(1).func_200916_a(BloodMagic.TAB));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        if (this == BloodMagicItems.LIVING_PLATE.get() || this == BloodMagicItems.LIVING_HELMET.get() || this == BloodMagicItems.LIVING_BOOTS.get()) {
            return "bloodmagic:models/armor/livingarmour_layer_1.png";
        }
        if (this == BloodMagicItems.LIVING_LEGGINGS.get()) {
            return "bloodmagic:models/armor/livingarmour_layer_2.png";
        }
        return null;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == BloodMagicItems.REAGENT_BINDING.get() || super.func_82789_a(toRepair, repair);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        if (this != BloodMagicItems.LIVING_PLATE.get()) {
            return super.damageItem(stack, amount, entity, onBroken);
        }
        int durRemaining = stack.func_77958_k() - 1 - stack.func_77952_i();
        int value = Math.max(Math.min(durRemaining, amount), 0);
        return value;
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        modifiers.putAll(super.getAttributeModifiers(slot, stack));
        if (slot != EquipmentSlotType.CHEST) {
            return modifiers;
        }
        if (this.getMaxDamage(stack) - this.getDamage(stack) <= 1) {
            return modifiers;
        }
        LivingStats stats = this.getLivingStats(stack);
        if (stats == null) {
            return modifiers;
        }
        stats.getUpgrades().forEach((arg_0, arg_1) -> ItemLivingArmor.lambda$getAttributeModifiers$0(stats, (Multimap)modifiers, arg_0, arg_1));
        return modifiers;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(group)) {
            return;
        }
        ItemStack stack = new ItemStack((IItemProvider)this);
        if (this.field_77881_a == EquipmentSlotType.CHEST) {
            this.updateLivingStats(stack, new LivingStats());
        }
        items.add((Object)stack);
    }

    @Override
    public void damageArmor(LivingEntity livingEntity, ItemStack stack, DamageSource source, float damage, EquipmentSlotType slot) {
        if (slot == EquipmentSlotType.CHEST && damage > (float)(this.func_77612_l() - stack.func_77952_i())) {
            livingEntity.func_70097_a(DamageSource.field_76376_m, 2.0f);
            return;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        ILivingContainer.appendLivingTooltip(stack, this.getLivingStats(stack), tooltip, true);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return this.hasElytraUpgrade(stack, entity) && stack.func_77952_i() < stack.func_77958_k() - 1;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        if (!entity.field_70170_p.field_72995_K && (flightTicks + 1) % 40 == 0) {
            stack.func_222118_a(1, entity, e -> e.func_213361_c(EquipmentSlotType.CHEST));
        }
        return true;
    }

    public boolean hasElytraUpgrade(ItemStack stack, LivingEntity entity) {
        if (stack.func_77973_b() instanceof ItemLivingArmor && entity instanceof PlayerEntity && LivingUtil.hasFullSet((PlayerEntity)entity)) {
            return LivingStats.fromPlayer((PlayerEntity)entity, true).getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_ELYTRA.get())).getKey()) > 0;
        }
        return false;
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$0(LivingStats stats, Multimap modifiers, LivingUpgrade k, Double v) {
        if (k.getAttributeProvider() != null) {
            k.getAttributeProvider().handleAttributes(stats, (Multimap<Attribute, AttributeModifier>)modifiers, UUID.nameUUIDFromBytes(k.getKey().toString().getBytes()), k, k.getLevel(v.intValue()));
        }
    }
}

