/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.OptionalDouble;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class BMRenderTypes {
    public static final RenderType SOLID_FULLBRIGHT;
    public static final RenderType TRANSLUCENT_LINES;
    public static final RenderType LINES;
    public static final RenderType TRANSLUCENT_TRIANGLES;
    public static final RenderType TRANSLUCENT_POSITION_COLOR;
    public static final RenderType TRANSLUCENT_NO_DEPTH;
    public static final RenderType CHUNK_MARKER;
    public static final RenderType VEIN_MARKER;
    public static final RenderType POSITION_COLOR_TEX_LIGHTMAP;
    public static final RenderType POSITION_COLOR_LIGHTMAP;
    public static final RenderType ITEM_DAMAGE_BAR;
    protected static final RenderState.ShadeModelState SHADE_ENABLED;
    protected static final RenderState.TextureState BLOCK_SHEET_MIPPED;
    protected static final RenderState.LightmapState LIGHTMAP_DISABLED;
    protected static final RenderState.TransparencyState TRANSLUCENT_TRANSPARENCY;
    protected static final RenderState.TransparencyState NO_TRANSPARENCY;
    protected static final RenderState.DepthTestState DEPTH_ALWAYS;

    public static RenderType getGui(ResourceLocation texture) {
        return RenderType.func_228632_a_((String)("gui_" + texture), (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228713_a_(new RenderState.AlphaState(0.5f)).func_228728_a_(false));
    }

    public static RenderType getLines(float lineWidth) {
        return RenderType.func_228632_a_((String)("lines_color_pos_" + lineWidth), (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228720_a_(new RenderState.LineState(OptionalDouble.of(lineWidth))).func_228724_a_(new RenderState.TextureState()).func_228728_a_(false));
    }

    public static RenderType getPoints(float pointSize) {
        RenderState.FogState setPointSize = new RenderState.FogState("bloodmagic:pointsize_" + pointSize, () -> GL11.glPointSize((float)pointSize), () -> GL11.glPointSize((float)1.0f));
        return RenderType.func_228632_a_((String)("point_pos_color_" + pointSize), (VertexFormat)DefaultVertexFormats.field_181706_f, (int)0, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228717_a_(setPointSize).func_228724_a_(new RenderState.TextureState()).func_228728_a_(false));
    }

    public static RenderType getPositionTex(ResourceLocation texture) {
        return RenderType.func_228632_a_((String)("bloodmagic:pos_tex_" + texture), (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228728_a_(false));
    }

    public static RenderType getFullbrightTranslucent(ResourceLocation resourceLocation) {
        RenderType.State glState = RenderType.State.func_228694_a_().func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228724_a_(new RenderState.TextureState(resourceLocation, false, false)).func_228719_a_(new RenderState.LightmapState(false)).func_228728_a_(false);
        return RenderType.func_228632_a_((String)("BloodMagic:fullbright_translucent_" + resourceLocation), (VertexFormat)DefaultVertexFormats.field_176600_a, (int)7, (int)256, (RenderType.State)glState);
    }

    public static IRenderTypeBuffer wrapWithStencil(IRenderTypeBuffer in, Consumer<IVertexBuilder> setupStencilArea, String name, int ref) {
        return BMRenderTypes.wrapWithAdditional(in, "stencil_" + name + "_" + ref, () -> {
            GL11.glEnable((int)2960);
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            RenderSystem.depthMask((boolean)false);
            GL11.glStencilFunc((int)512, (int)1, (int)255);
            GL11.glStencilOp((int)7681, (int)7680, (int)7680);
            GL11.glStencilMask((int)255);
            RenderSystem.clear((int)1024, (boolean)true);
            RenderSystem.disableTexture();
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder bb = tes.func_178180_c();
            bb.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            setupStencilArea.accept((IVertexBuilder)bb);
            tes.func_78381_a();
            RenderSystem.enableTexture();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.depthMask((boolean)true);
            GL11.glStencilMask((int)0);
            GL11.glStencilFunc((int)514, (int)ref, (int)255);
        }, () -> GL11.glDisable((int)2960));
    }

    public static IRenderTypeBuffer disableLighting(IRenderTypeBuffer in) {
        return BMRenderTypes.wrapWithAdditional(in, "no_lighting", RenderSystem::disableLighting, () -> {});
    }

    public static IRenderTypeBuffer disableCull(IRenderTypeBuffer in) {
        return BMRenderTypes.wrapWithAdditional(in, "no_cull", RenderSystem::disableCull, RenderSystem::enableCull);
    }

    private static IRenderTypeBuffer wrapWithAdditional(IRenderTypeBuffer in, String name, Runnable setup, Runnable teardown) {
        return type -> in.getBuffer(new RenderType("bloodmagic:" + type + "_" + name, type.func_228663_p_(), type.func_228664_q_(), type.func_228662_o_(), type.func_228665_s_(), false, () -> {
            type.func_228547_a_();
            setup.run();
        }, () -> {
            teardown.run();
            type.func_228549_b_();
        }){});
    }

    static {
        SHADE_ENABLED = new RenderState.ShadeModelState(true);
        BLOCK_SHEET_MIPPED = new RenderState.TextureState(AtlasTexture.field_110575_b, false, true);
        LIGHTMAP_DISABLED = new RenderState.LightmapState(false);
        TRANSLUCENT_TRANSPARENCY = new RenderState.TransparencyState("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }, RenderSystem::disableBlend);
        NO_TRANSPARENCY = new RenderState.TransparencyState("no_transparency", RenderSystem::disableBlend, () -> {});
        DEPTH_ALWAYS = new RenderState.DepthTestState("", 519);
        RenderType.State fullbrightSolidState = RenderType.State.func_228694_a_().func_228723_a_(SHADE_ENABLED).func_228719_a_(LIGHTMAP_DISABLED).func_228724_a_(BLOCK_SHEET_MIPPED).func_228728_a_(true);
        SOLID_FULLBRIGHT = RenderType.func_228632_a_((String)"bloodmagic:block_fullbright", (VertexFormat)DefaultVertexFormats.field_176600_a, (int)7, (int)256, (RenderType.State)fullbrightSolidState);
        RenderType.State translucentNoDepthState = RenderType.State.func_228694_a_().func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228720_a_(new RenderState.LineState(OptionalDouble.of(2.0))).func_228724_a_(new RenderState.TextureState()).func_228715_a_(DEPTH_ALWAYS).func_228728_a_(false);
        RenderType.State translucentNoTextureState = RenderType.State.func_228694_a_().func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228724_a_(new RenderState.TextureState()).func_228728_a_(false);
        TRANSLUCENT_LINES = RenderType.func_228632_a_((String)"bloodmagic:translucent_lines", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)256, (RenderType.State)translucentNoDepthState);
        LINES = RenderType.func_228632_a_((String)"bloodmagic:lines", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228728_a_(false));
        TRANSLUCENT_TRIANGLES = RenderType.func_228632_a_((String)"bloodmagic:translucent_triangle_fan", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)4, (int)256, (RenderType.State)translucentNoDepthState);
        TRANSLUCENT_POSITION_COLOR = RenderType.func_228632_a_((String)"bloodmagic:translucent_pos_color", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (RenderType.State)translucentNoTextureState);
        TRANSLUCENT_NO_DEPTH = RenderType.func_228632_a_((String)"bloodmagic:translucent_no_depth", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (RenderType.State)translucentNoDepthState);
        RenderType.State chunkMarkerState = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState()).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228714_a_(new RenderState.CullState(false)).func_228723_a_(new RenderState.ShadeModelState(true)).func_228720_a_(new RenderState.LineState(OptionalDouble.of(5.0))).func_228728_a_(false);
        CHUNK_MARKER = RenderType.func_228632_a_((String)"bloodmagic:chunk_marker", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)256, (RenderType.State)chunkMarkerState);
        VEIN_MARKER = RenderType.func_228632_a_((String)"bloodmagic:vein_marker", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)2, (int)256, (RenderType.State)chunkMarkerState);
        POSITION_COLOR_TEX_LIGHTMAP = RenderType.func_228632_a_((String)"bloodmagic:pos_color_tex_lightmap", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(PlayerContainer.field_226615_c_, false, false)).func_228719_a_(new RenderState.LightmapState(true)).func_228728_a_(false));
        POSITION_COLOR_LIGHTMAP = RenderType.func_228632_a_((String)"bloodmagic:pos_color_lightmap", (VertexFormat)DefaultVertexFormats.field_227850_m_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState()).func_228719_a_(new RenderState.LightmapState(true)).func_228728_a_(false));
        ITEM_DAMAGE_BAR = RenderType.func_228632_a_((String)"bloodmagic:item_damage_bar", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228715_a_(DEPTH_ALWAYS).func_228724_a_(new RenderState.TextureState()).func_228713_a_(new RenderState.AlphaState(0.0f)).func_228726_a_(NO_TRANSPARENCY).func_228728_a_(false));
    }
}

