/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.client.screens.ScreenBase;
import wayoftime.bloodmagic.network.BloodMagicPacketHandler;
import wayoftime.bloodmagic.network.ItemRoutingNodeButtonPacket;
import wayoftime.bloodmagic.tile.container.ContainerItemRoutingNode;
import wayoftime.bloodmagic.tile.routing.TileFilteredRoutingNode;

public class ScreenItemRoutingNode
extends ScreenBase<ContainerItemRoutingNode> {
    private static final ResourceLocation background = new ResourceLocation("bloodmagic", "textures/gui/routingnode.png");
    public TileFilteredRoutingNode tileNode;
    private Direction playerFacing;
    private Direction horizontalFacing;
    private int left;
    private int top;

    public ScreenItemRoutingNode(ContainerItemRoutingNode container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.tileNode = container.tileNode;
        this.field_146999_f = 176;
        this.field_147000_g = 187;
        Vector3d facingVec = Vector3d.func_189984_a((Vector2f)playerInventory.field_70458_d.func_189653_aC());
        this.playerFacing = Direction.func_210769_a((double)facingVec.field_72450_a, (double)facingVec.field_72448_b, (double)facingVec.field_72449_c);
        this.horizontalFacing = playerInventory.field_70458_d.func_174811_aO();
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.left = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.top = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.field_230710_m_.clear();
        for (int i = 0; i < 6; ++i) {
            Direction dir = this.getFilterDirectionForButton(i);
            Pair<Integer, Integer> buttonLocation = this.getButtonLocation(i);
            String dirName = this.getStringForDirection(dir);
            if (!this.tileNode.func_145831_w().func_175623_d(this.tileNode.getBlockPos().func_177972_a(dir))) {
                dirName = "";
            }
            this.func_230480_a_((Widget)new Button(this.left + (Integer)buttonLocation.getLeft(), this.top + (Integer)buttonLocation.getRight(), 20, 20, (ITextComponent)new StringTextComponent(dirName), (Button.IPressable)new DirectionalPress(this, this.tileNode, i, dir)));
            if (dir.ordinal() != this.tileNode.getCurrentActiveSlot()) continue;
            this.disableDirectionalButton(i);
        }
        this.func_230480_a_((Widget)new Button(this.left + 89, this.top + 50, 8, 20, (ITextComponent)new StringTextComponent(">"), (Button.IPressable)new IncrementPress(this.tileNode, 6)));
        this.func_230480_a_((Widget)new Button(this.left + 61, this.top + 50, 8, 20, (ITextComponent)new StringTextComponent("<"), (Button.IPressable)new IncrementPress(this.tileNode, 7)));
    }

    public Direction getFilterDirectionForButton(int button) {
        if (button == 2) {
            return this.playerFacing;
        }
        if (button == 5) {
            return this.playerFacing.func_176734_d();
        }
        if (this.playerFacing == Direction.UP) {
            switch (button) {
                case 0: {
                    return this.horizontalFacing.func_176734_d();
                }
                case 4: {
                    return this.horizontalFacing;
                }
                case 1: {
                    return this.horizontalFacing.func_176735_f();
                }
                case 3: {
                    return this.horizontalFacing.func_176746_e();
                }
            }
        } else if (this.playerFacing == Direction.DOWN) {
            switch (button) {
                case 0: {
                    return this.horizontalFacing;
                }
                case 4: {
                    return this.horizontalFacing.func_176734_d();
                }
                case 1: {
                    return this.horizontalFacing.func_176735_f();
                }
                case 3: {
                    return this.horizontalFacing.func_176746_e();
                }
            }
        } else {
            switch (button) {
                case 0: {
                    return Direction.UP;
                }
                case 4: {
                    return Direction.DOWN;
                }
                case 1: {
                    return this.horizontalFacing.func_176735_f();
                }
                case 3: {
                    return this.horizontalFacing.func_176746_e();
                }
            }
        }
        return Direction.UP;
    }

    public String getStringForDirection(Direction dir) {
        switch (dir) {
            case DOWN: {
                return "D";
            }
            case EAST: {
                return "E";
            }
            case NORTH: {
                return "N";
            }
            case SOUTH: {
                return "S";
            }
            case UP: {
                return "U";
            }
            case WEST: {
                return "W";
            }
        }
        return "";
    }

    @Override
    public ResourceLocation getBackground() {
        return background;
    }

    protected void func_230451_b_(MatrixStack stack, int mouseX, int mouseY) {
        this.field_230712_o_.func_243248_b(stack, (ITextComponent)new StringTextComponent("" + this.getCurrentActiveSlotPriority()), 76.0f, 56.0f, 0xFFFFFF);
        BlockPos tilePos = this.tileNode.getBlockPos();
        World world = this.tileNode.func_145831_w();
        for (int i = 0; i < 6; ++i) {
            Direction dir = this.getFilterDirectionForButton(i);
            Pair<Integer, Integer> buttonLocation = this.getButtonLocation(i);
            BlockState blockState = world.func_180495_p(tilePos.func_177972_a(dir));
            Block block = blockState.func_177230_c();
            if (block == null) continue;
            ItemStack itemStack = new ItemStack((IItemProvider)block);
            this.drawItemStack(itemStack, (Integer)buttonLocation.getLeft() + 2, (Integer)buttonLocation.getRight() + 2, this.getStringForDirection(dir));
        }
    }

    public Pair<Integer, Integer> getButtonLocation(int button) {
        switch (button) {
            case 0: {
                return Pair.of((Object)129, (Object)11);
            }
            case 1: {
                return Pair.of((Object)109, (Object)31);
            }
            case 2: {
                return Pair.of((Object)129, (Object)31);
            }
            case 3: {
                return Pair.of((Object)149, (Object)31);
            }
            case 4: {
                return Pair.of((Object)129, (Object)51);
            }
            case 5: {
                return Pair.of((Object)149, (Object)51);
            }
        }
        return Pair.of((Object)0, (Object)0);
    }

    private int getCurrentActiveSlotPriority() {
        Direction direction = Direction.func_82600_a((int)this.tileNode.getCurrentActiveSlot());
        if (direction != null) {
            return this.tileNode.getPriority(direction);
        }
        return 0;
    }

    private void enableAllDirectionalButtons() {
        for (Widget button : this.field_230710_m_) {
            button.field_230693_o_ = true;
        }
    }

    private void disableDirectionalButton(int id) {
        ((Widget)this.field_230710_m_.get((int)id)).field_230693_o_ = false;
    }

    @Override
    protected void func_230450_a_(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(background);
        int i = (this.field_230708_k_ - this.field_146999_f) / 2;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(stack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    private void drawItemStack(ItemStack stack, int x, int y, String altText) {
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.func_230926_e_(1);
        this.field_230707_j_.field_77023_b = 1.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_230712_o_;
        }
        this.field_230707_j_.func_180450_b(stack, x, y);
        int offset = 8;
        this.field_230707_j_.func_180453_a(font, stack, x, y - offset, altText);
        this.func_230926_e_(0);
        this.field_230707_j_.field_77023_b = 0.0f;
    }

    public class DirectionalPress
    implements Button.IPressable {
        private final ScreenItemRoutingNode screen;
        private final TileFilteredRoutingNode node;
        private final int id;
        private final Direction direction;

        public DirectionalPress(ScreenItemRoutingNode screen, TileFilteredRoutingNode node, int id, Direction direction) {
            this.screen = screen;
            this.node = node;
            this.id = id;
            this.direction = direction;
        }

        public void onPress(Button button) {
            if (button.field_230693_o_) {
                BloodMagicPacketHandler.INSTANCE.sendToServer((Object)new ItemRoutingNodeButtonPacket(this.node.func_174877_v(), this.direction.ordinal()));
                if (this.id < 6) {
                    ScreenItemRoutingNode.this.tileNode.setCurrentActiveSlot(this.direction.ordinal());
                    this.screen.enableAllDirectionalButtons();
                    this.screen.disableDirectionalButton(this.id);
                }
            }
        }
    }

    public class IncrementPress
    implements Button.IPressable {
        private final TileFilteredRoutingNode node;
        private final int id;

        public IncrementPress(TileFilteredRoutingNode node, int id) {
            this.node = node;
            this.id = id;
        }

        public void onPress(Button button) {
            if (button.field_230693_o_) {
                BloodMagicPacketHandler.INSTANCE.sendToServer((Object)new ItemRoutingNodeButtonPacket(this.node.func_174877_v(), this.id));
            }
        }
    }
}

