/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.hud;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Point;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import wayoftime.bloodmagic.client.hud.ElementRegistry;
import wayoftime.bloodmagic.client.hud.element.HUDElement;

public class GuiEditHUD
extends Screen {
    private static final int LINE_COLOR = 0x2D2D2D;
    private final Screen parent;
    private final Map<ResourceLocation, Vector2f> currentOverrides = Maps.newHashMap();
    private HUDElement dragged;
    public boolean changes;

    public GuiEditHUD(Screen parent) {
        super((ITextComponent)new StringTextComponent("Testing GuiEditHUD"));
        this.parent = parent;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 155, this.field_230709_l_ - 30, 70, 20, (ITextComponent)new TranslationTextComponent("gui.bloodmagic.toggle"), b -> Minecraft.func_71410_x().func_147108_a(this.parent)){
            {
                this.field_230693_o_ = false;
            }
        });
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 75, this.field_230709_l_ - 30, 70, 20, (ITextComponent)new TranslationTextComponent("gui.bloodmagic.default"), b -> {
            this.currentOverrides.clear();
            ElementRegistry.resetPos();
            this.changes = false;
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 5, this.field_230709_l_ - 30, 70, 20, (ITextComponent)new TranslationTextComponent("gui.bloodmagic.save"), b -> {
            ElementRegistry.save(this.currentOverrides);
            Minecraft.func_71410_x().func_147108_a(this.parent);
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 90, this.field_230709_l_ - 30, 70, 20, (ITextComponent)new TranslationTextComponent("gui.bloodmagic.cancel"), b -> {
            this.currentOverrides.clear();
            Minecraft.func_71410_x().func_147108_a(this.parent);
        }));
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        for (HUDElement element : ElementRegistry.getElements()) {
            if (this.dragged == element) continue;
            ResourceLocation key = ElementRegistry.getKey(element);
            Vector2f position = this.currentOverrides.getOrDefault(key, ElementRegistry.getPosition(key));
            int xPos = (int)((float)window.func_198107_o() * position.field_189982_i);
            int yPos = (int)((float)window.func_198087_p() * position.field_189983_j);
            this.drawWithBox(matrixStack, element, partialTicks, xPos, yPos);
        }
        if (this.dragged != null) {
            Point bounded = this.getBoundedDrag(window, mouseX, mouseY);
            this.drawWithBox(matrixStack, this.dragged, partialTicks, bounded.x, bounded.y);
        }
    }

    public boolean func_231177_au__() {
        return true;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        HUDElement element;
        if (this.dragged == null && (element = this.getHoveredElement(mouseX, mouseY)) != null && button == 0) {
            this.dragged = element;
        }
        return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int state) {
        if (this.dragged != null) {
            MainWindow window = Minecraft.func_71410_x().func_228018_at_();
            Point bounded = this.getBoundedDrag(window, mouseX, mouseY);
            float xPos = bounded.x / window.func_198107_o();
            float yPos = bounded.y / window.func_198087_p();
            this.currentOverrides.put(ElementRegistry.getKey(this.dragged), new Vector2f(xPos, yPos));
            this.changes = true;
            this.dragged = null;
        }
        return super.func_231048_c_(mouseX, mouseY, state);
    }

    @Nullable
    public HUDElement getHoveredElement(double mouseX, double mouseY) {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        for (HUDElement element : ElementRegistry.getElements()) {
            ResourceLocation key = ElementRegistry.getKey(element);
            Vector2f position = this.currentOverrides.getOrDefault(key, ElementRegistry.getPosition(key));
            int xPos = (int)((float)window.func_198107_o() * position.field_189982_i);
            int yPos = (int)((float)window.func_198087_p() * position.field_189983_j);
            if (mouseX < (double)xPos || mouseX > (double)(xPos + element.getWidth()) || mouseY < (double)yPos || mouseY > (double)(yPos + element.getHeight())) continue;
            return element;
        }
        return null;
    }

    protected Point getBoundedDrag(MainWindow window, double mouseX, double mouseY) {
        int drawY;
        int drawX = (int)(mouseX - (double)(this.dragged.getWidth() / 2));
        if (drawX + this.dragged.getWidth() >= window.func_198107_o()) {
            drawX = window.func_198107_o() - this.dragged.getWidth();
        }
        if (drawX < 0) {
            drawX = 0;
        }
        if ((drawY = (int)(mouseY - (double)(this.dragged.getHeight() / 2))) + this.dragged.getHeight() >= window.func_198087_p()) {
            drawY = window.func_198087_p() - this.dragged.getHeight();
        }
        if (drawY < 0) {
            drawY = 0;
        }
        return new Point(drawX, drawY);
    }

    protected void drawWithBox(MatrixStack matrixStack, HUDElement element, float partialTicks, int drawX, int drawY) {
        int color = ElementRegistry.getColor(ElementRegistry.getKey(element));
        matrixStack.func_227860_a_();
        this.func_238473_b_(matrixStack, drawX, drawY, drawY + element.getHeight() - 1, color);
        this.func_238473_b_(matrixStack, drawX + element.getWidth() - 1, drawY, drawY + element.getHeight() - 1, color);
        this.func_238465_a_(matrixStack, drawX, drawX + element.getWidth() - 1, drawY, color);
        this.func_238465_a_(matrixStack, drawX, drawX + element.getWidth() - 1, drawY + element.getHeight() - 1, color);
        matrixStack.func_227865_b_();
        element.draw(matrixStack, partialTicks, drawX, drawY);
    }
}

