/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.anointment;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;
import wayoftime.bloodmagic.anointment.AnointmentHolder;
import wayoftime.bloodmagic.core.living.LivingUpgrade;

@JsonAdapter(value=Deserializer.class)
public class Anointment
extends ForgeRegistryEntry<Anointment> {
    public static final Anointment DUMMY = new Anointment(new ResourceLocation("dummy"));
    private final ResourceLocation key;
    private final Set<ResourceLocation> incompatible;
    private String translationKey = null;
    private final Map<String, Bonus> bonuses;
    private IAttributeProvider attributeProvider;
    private IDamageProvider damageProvider;
    private boolean consumeOnAttack = false;
    private boolean consumeOnUseFinish = false;
    private boolean consumeOnHarvest = false;

    public Anointment(ResourceLocation key) {
        this.key = key;
        this.incompatible = Sets.newHashSet();
        this.bonuses = Maps.newHashMap();
    }

    public Anointment withBonusSet(String id, Consumer<List<Number>> modifiers) {
        ArrayList<Number> values2 = new ArrayList<Number>();
        modifiers.accept(values2);
        this.bonuses.put(id, new Bonus(id, values2));
        return this;
    }

    public Number getBonusValue(String id, int level) {
        List modifiers = this.bonuses.getOrDefault(id, Bonus.DEFAULT).modifiers;
        if (modifiers.isEmpty() || level == 0) {
            return 0;
        }
        return level <= modifiers.size() ? (Number)((Number)modifiers.get(level - 1)) : (Number)((Number)modifiers.get(modifiers.size() - 1));
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    public String toString() {
        return this.key.toString();
    }

    public boolean applyAnointment(AnointmentHolder holder, ItemStack stack, int level) {
        if (level < 0) {
            return false;
        }
        IAttributeProvider prov = this.getAttributeProvider();
        if (prov == null) {
            return true;
        }
        HashMultimap modifiers = HashMultimap.create();
        modifiers.putAll(stack.func_77973_b().getAttributeModifiers(EquipmentSlotType.MAINHAND, stack));
        this.getAttributeProvider().handleAttributes(holder, (Multimap<Attribute, AttributeModifier>)modifiers, UUID.nameUUIDFromBytes(this.getKey().toString().getBytes()), this, level);
        for (Map.Entry entry : modifiers.entries()) {
            stack.func_185129_a((Attribute)entry.getKey(), (AttributeModifier)entry.getValue(), EquipmentSlotType.MAINHAND);
        }
        return true;
    }

    public boolean removeAnointment(AnointmentHolder holder, ItemStack stack, EquipmentSlotType slot) {
        IAttributeProvider provider = this.getAttributeProvider();
        if (provider != null) {
            HashMultimap modifiers = HashMultimap.create();
            this.getAttributeProvider().handleAttributes(holder, (Multimap<Attribute, AttributeModifier>)modifiers, UUID.nameUUIDFromBytes(this.getKey().toString().getBytes()), this, 1);
            if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("AttributeModifiers", 9)) {
                ListNBT listnbt = stack.func_77978_p().func_150295_c("AttributeModifiers", 10);
                ArrayList<Integer> removeList = new ArrayList<Integer>();
                for (int i = 0; i < listnbt.size(); ++i) {
                    AttributeModifier attributemodifier;
                    Optional optional;
                    CompoundNBT compoundnbt = listnbt.func_150305_b(i);
                    if (compoundnbt.func_150297_b("Slot", 8) && !compoundnbt.func_74779_i("Slot").equals(slot.func_188450_d()) || !(optional = Registry.field_239692_aP_.func_241873_b(ResourceLocation.func_208304_a((String)compoundnbt.func_74779_i("AttributeName")))).isPresent() || (attributemodifier = AttributeModifier.func_233800_a_((CompoundNBT)compoundnbt)) == null || attributemodifier.func_111167_a().getLeastSignificantBits() == 0L || attributemodifier.func_111167_a().getMostSignificantBits() == 0L) continue;
                    for (Map.Entry entry : modifiers.entries()) {
                        if (!((Attribute)entry.getKey()).equals(optional.get()) || !((AttributeModifier)entry.getValue()).func_111167_a().equals(attributemodifier.func_111167_a())) continue;
                        removeList.add(i);
                    }
                }
                Iterator iterator = removeList.iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    listnbt.remove(index);
                }
                if (removeList.size() >= 1) {
                    stack.func_77978_p().func_218657_a("AttributeModifiers", (INBT)listnbt);
                    if (listnbt.isEmpty()) {
                        stack.func_77978_p().func_82580_o("AttributeModifiers");
                    }
                }
            }
        }
        return false;
    }

    public boolean isCompatible(ResourceLocation otherUpgrade) {
        return !this.incompatible.contains(otherUpgrade);
    }

    public Anointment addIncompatibility(ResourceLocation key, ResourceLocation ... otherKeys) {
        this.incompatible.add(key);
        Collections.addAll(this.incompatible, otherKeys);
        return this;
    }

    public String getTranslationKey() {
        return this.translationKey == null ? (this.translationKey = Util.func_200697_a((String)"anointment", (ResourceLocation)this.key)) : this.translationKey;
    }

    public Anointment setConsumeOnAttack() {
        this.consumeOnAttack = true;
        return this;
    }

    public boolean consumeOnAttack() {
        return this.consumeOnAttack;
    }

    public Anointment setConsumeOnUseFinish() {
        this.consumeOnUseFinish = true;
        return this;
    }

    public boolean consumeOnUseFinish() {
        return this.consumeOnUseFinish;
    }

    public Anointment setConsumeOnHarvest() {
        this.consumeOnHarvest = true;
        return this;
    }

    public boolean consumeOnHarvest() {
        return this.consumeOnHarvest;
    }

    public Anointment withAttributeProvider(IAttributeProvider attributeProvider) {
        this.attributeProvider = attributeProvider;
        return this;
    }

    public IAttributeProvider getAttributeProvider() {
        return this.attributeProvider;
    }

    public Anointment withDamageProvider(IDamageProvider damageProvider) {
        this.damageProvider = damageProvider;
        return this;
    }

    public IDamageProvider getDamageProvider() {
        return this.damageProvider;
    }

    public static class Bonus {
        private static final Bonus DEFAULT = new Bonus("null", Collections.emptyList());
        private final String id;
        private final List<Number> modifiers;

        public Bonus(String id, List<Number> modifiers) {
            this.id = id;
            this.modifiers = modifiers;
        }

        public String getId() {
            return this.id;
        }
    }

    public static interface IAttributeProvider {
        public void handleAttributes(AnointmentHolder var1, Multimap<Attribute, AttributeModifier> var2, UUID var3, Anointment var4, int var5);
    }

    public static interface IDamageProvider {
        public double getAdditionalDamage(PlayerEntity var1, ItemStack var2, double var3, AnointmentHolder var5, LivingEntity var6, Anointment var7, int var8);
    }

    public static class Deserializer
    implements JsonDeserializer<Anointment> {
        public Anointment deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = element.getAsJsonObject();
            ResourceLocation id = new ResourceLocation(json.getAsJsonPrimitive("id").getAsString());
            List levels = (List)context.deserialize((JsonElement)json.getAsJsonArray("levels"), new TypeToken<List<LivingUpgrade.Level>>(){}.getType());
            boolean negative = json.has("negative") && json.getAsJsonPrimitive("negative").getAsBoolean();
            Anointment upgrade = new Anointment(id);
            if (json.has("bonuses")) {
                Map bonuses = (Map)context.deserialize((JsonElement)json.getAsJsonObject("bonuses"), new TypeToken<Map<String, Number[]>>(){}.getType());
                bonuses.forEach((k, v) -> upgrade.withBonusSet((String)k, numbers -> Collections.addAll(numbers, v)));
            }
            return upgrade;
        }
    }
}

